
#ifndef _1_CRYS_ATP_TST_UTIL_OTF_FUNCS_H
#define _1_CRYS_ATP_TST_UTIL_OTF_FUNCS_H
  /*
   *  Object %name    : % CRYS_ATP_TST_UTIL_OTF_Funcs.h
   *  State           :  %state%
   *  Creation date   :  03 Oct 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_UTIL_OTF_Funcs.h#1:incl:1
   *  \author R.Levin
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

#include "DX_VOS_BaseTypes.h"
#include "PLAT_SystemDep.h"
#include "CRYS_COMMON.h"

/************************ Defines **********************************/

/* defining a macro for waiting to the CSI_READ_FINISH busy register */
#define CRYS_ATP_TST_CSI_READ_FINISH_WAIT( ) \
do \
{ \
   DxUint32_t csi_read_finish_wait_i; \
   volatile CSI_Status_t CSI_Status = CSI_BUSY; \
   for(csi_read_finish_wait_i = 0; csi_read_finish_wait_i < 10 ; csi_read_finish_wait_i++);\
   do \
   { \
      CSI_GetStatus( &CSI_Status ); \
   }while( CSI_Status != CSI_DONE ); \
}while(0)
  
/***************************************************************************************************/
/**
 * @brief This macro is used for waiting to FIFO_IN_EMPTY register. 
 *
 *        The macro function executes a polling on FIFO_IN_EMPTY value until
 *        it is 1.
 *
 *
 * @param[in] - VirtualHwBaseAddr.
 * 
 * @return DxInt32_t - none
 */
/* defining a macro for waiting to the FIFO_IN_EMPTY busy register */
#define CRYS_ATP_TST_CSI_FIFO_IN_EMPTY_WAIT( VirtualHwBaseAddr ) \
do \
{ \
   volatile DxUint32_t output_reg_val;\
   for(output_reg_val = 0; output_reg_val < 20 ; output_reg_val++);\
   do \
   { \
      CRYS_PLAT_SYS_ReadRegister( (VirtualHwBaseAddr) + HW_FIFO_IN_EMPTY_REG_ADDR , output_reg_val ); \
   }while( !output_reg_val ); \
}while(0)

/************************ Enums ************************************/

typedef enum
{
  	CSI_TST_OTF_DMA_TO_DMA = 0,
	CSI_TST_OTF_CSI_TO_CSI = 1,
	CSI_TST_OTF_CSI_TO_DMA = 2,
	CSI_TST_OTF_DMA_TO_CSI = 3,
	
	CSI_TST_OTF_OffMode,
	
	TST_OTF_CSI_IN_OUT_ModeLast= 0x7FFFFFFF,

} TST_OTF_CSI_IN_OUT_Mode_t;


/************************ Typedefs *********************************/

/************************ Global Data ******************************/


/*******************************************************************/
/*********                 Pubic Functions                   *******/
/*******************************************************************/



/************************************************************************************************
 * Function Name: 
 *   CRYS_ATP_TST_CSI_Write
 *
 * Inputs:
 *   DxUint8_t DataIn_ptr        -  The pointer to the users data intput buffer .
 *   Dxuint8_t DataOut_ptr       -  The pointer to the users data output buffer .
 *   DxUint32_t DataSize          -  The test data size, must be not great than 4KB (max FiFo size).
 *   TST_CSI_IN_OUT_Mode_t TST_InOutMode   -  The input-output mode (combination of CSI and DMA), 
 *                                 defined in enumerator.
 * 
 * @return CRYSError_t - On success CRYS_OK or an error is returned
 * 
 * Description: write function initializes the CSI master registers and initializes
 *              the FiFo memory for testing crypto functions on CSI mode. This function
 *              comes to demonstartes writing to the flash 
 ************************************************************************************************/                                               
  CRYSError_t  CRYS_ATP_TST_CSI_Write( DxUint8_t             *DataIn_ptr ,
                                       DxUint8_t             *DataOut_ptr ,
                                       DxUint32_t             DataInSize,
                                       TST_OTF_CSI_IN_OUT_Mode_t  TST_InOutMode );                   

/************************************************************************************************
 * Function Name: 
 *   CRYS_ATP_TST_CSI_Read
 *
 * Inputs:
 *   DxUint8_t DataOut_ptr       -  The pointer to the users data output buffer .
 *   DxUint32_t DataSize          -  The test data size, must be not great than 4KB (max FiFo size).
 *   TST_CSI_IN_OUT_Mode_t TST_InOutMode   -  The input-output mode (combination of CSI and DMA), 
 *                                 defined in enumerator.
 * 
 * @return CRYSError_t - On success CRYS_OK or an error is returned
 * 
 * Description: the function finishes the CSI operations and output of the 
 *              result data from the FiFo memory. 
 ************************************************************************************************/                              
  CRYSError_t  CRYS_ATP_TST_CSI_Read( DxUint8_t             *DataOut_ptr,
        				              DxUint32_t             DataOutSize,
      				                  TST_OTF_CSI_IN_OUT_Mode_t  TST_InOutMode );                   


#endif
